# Description
This command line application attempts to find the perfect offset to maximize the star rating for your beatmap.
This works by exploiting strain chunking inside pp calculations.

As beatmaps are processed in 400ms chunks, objects can fit in different chunks depending on the offset.
This means that changing the offset will also change star rating.
The perfect offset changes with different speeds (DT vs Nomod vs HT, also breaks rate adjust sometimes).
Additionally, depending on the maps themselves, the perfect offset can vary between difficulties.

The application first takes an `.osu` file, which should be located in its beatmap folder with its audio file.
It then finds the best possible offset by bruteforcing 600 maps each with a different offset.
After that, you can choose to apply this to only the selected difficulty, or the entire mapset.
If you have `FFmpeg` installed, you can then choose to create a new audio file with the desired offset.
There is no need to do any additional manual changes.



> [!IMPORTANT]
> Extract `Offsetmaxxer.zip` into an empty folder. Both `lib` and `Offsetmaxxer` must be present.
> If you want the application to create audio files, install FFmpeg.
> You can download `FFmpeg` [here](https://github.com/BtbN/FFmpeg-Builds/releases/download/autobuild-2024-12-30-12-59/ffmpeg-n7.1-62-gb168ed9b14-win64-gpl-7.1.zip).

# Instructions
Run `Offsetmaxxer.exe`.
You will first be prompted to select a .osu beatmap file. 
The default osu! map folder is `C:\Users\YourUsernameHere\AppData\Local\osu!\Songs`.
If you can't find it, open a map in the editor, press `File` in the top left corner and press `Open Song Folder`.
Then, type the number corresponding to what you want to do and press `ENTER`.

# Example 
Pressing `3` then `ENTER` will find the perfect offset for the DT mod. 
Afterwards, pressing `4` then `ENTER` will generate a new folder called `Offsetmaxxer`, in the same place as the map file, with the edited `.osu` file. 
Finally, pressing `1` then `ENTER` will generate a new edited audio file (.mp3, .ogg, 192kbps) in the same folder. This requires `FFmpeg`, which is explained above.

> [!WARNING]
> If you experience any errors during audio export, place an `ffmpeg.exe` file in the same folder as `Offsetmaxxer.exe`
> If you experience any other errors, message `The Fart Lord` on osu!

# Acknowledgments
Thanks to Badewanne3 for the python [pp calculator](https://github.com/MaxOhn/rosu-pp-py).

Thanks to Fred727 for the main beatmap [parser and generator](https://osu.ppy.sh/users/5055826).

Audio creation requires [FFmpeg](https://github.com/BtbN/FFmpeg-Builds/releases).

# Changelog

> 1.1 (26/04/2025)
Updated to [March 2025 pp](https://osu.ppy.sh/home/news/2025-03-06-performance-points-star-rating-updates)
Added stable pp calculations (ew)
Cleaned up and formatted terminal output slightly

> 1.2 (01/05/2025)
Added video offset
Added attempt to open offsetmaxxed mapset folder in File Explorer
Cleaned up and formatted terminal output a bit more